<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\IndividualTopUpController;
use Illuminate\Support\Facades\Log;

class MixingTopUpController extends Controller
{
    protected $individualTopUp;

    public function __construct(IndividualTopUpController $individualTopUpController) {
        $this->individualTopUp = $individualTopUpController;
    }

    public function TopUp(Request $request){

        $shell_code = $request->shell_code;
        $memberships = [
            "weekly_lite_membership" => $request->weekly_lite_membership,
            "weekly_membership" => $request->weekly_membership,
            "monthly_membership" => $request->monthly_membership
        ];

        $item_ids = [
            "weekly_lite_membership" => 4010,
            "weekly_membership" => 7,
            "monthly_membership" => 8
        ];

        $player_session = $this->individualTopUp->GetSessionKeyFromHeader($request->player_id);
        
        if (!$player_session['session_key']) {
            $transaction = [
                'playerId' => $request->player_id,
                'playerName' => $request->playerName ?? 'Unknown',
                'packageName' => $request->packageName ?? ''
            ];
    
            $response_data = [
                'result' => 'error'
            ];
    
            $this->individualTopUp->SendTelegramMessage($transaction, $response_data, '');
            return response()->json(['status' => 'failed', 'message' => 'Failed to get session key'], 400);
        }

        if($player_session['session_key']){
            $this->ProcessEachMembership($memberships,$item_ids, $request, $player_session, $shell_code);
        }
    }

    protected function ProcessEachMembership($memberships, $item_ids, $request, $player_session,$shell_code){
        foreach ($memberships as $key => $count) {
            $item_id = $item_ids[$key];
        
            if ($count > 0) {
                for ($i = 0; $i < $count; $i++) {
                    $retryCount = 0;
        
                    while ($retryCount < 3) {
                        $otp = $this->individualTopUp->generate($request->fa_key);
                        $topup_responce = $this->individualTopUp->PrepairTopUpHeader($player_session, $otp, $item_id, $shell_code, $request, $key);

                        if (isset($topup_responce['response']['result']) && $topup_responce['response']['result'] == "error_2sa_otp") {
                            $retryCount++;
                            Log::error("Mix Top-up $retryCount attempts for item_id: $item_id");
                            if ($retryCount >= 3) {
                                Log::error("******* Mix Top-up failed after 3 attempts for item_id: $item_id, key: $key *******");
                                break;
                            }
                        } else {
                            Log::error("Mix Top-up Success Key: $key, OTP: $otp");
                            break;
                        }
                    }
                }
            }
        }
        
    }
}
